% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/footprint.R
\name{plotFootprint}
\alias{plotFootprint}
\title{A function to plot footprint of paired-end data at given loci}
\usage{
plotFootprint(
  frags,
  targets,
  split_strand = FALSE,
  plot_central = TRUE,
  xlim = c(-75, 75),
  bin = 1,
  verbose = 1
)
}
\arguments{
\item{frags}{GRanges, the paired-end fragments}

\item{targets}{GRanges, the loci to map the fragments onto}

\item{split_strand}{Boolean, should the + and - strand be splitted?}

\item{plot_central}{plot grey rectangle over the loci}

\item{xlim}{numeric vector of length 2, the x limits of the computed Vmat}

\item{bin}{Integer, bin used to smooth the gootprint profile}

\item{verbose}{Integer}
}
\value{
A footprint ggplot
}
\description{
This function takes paired-end fragments, extract the "cuts" (i.e.
extremities) and plot the footprint profile over a set of GRanges.
}
\examples{
data(bam_test)
data(ce11_proms)
plotFootprint(bam_test, ce11_proms)
}
