% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nucleosome_enrichment.R
\name{nucleosomeEnrichment.GRanges}
\alias{nucleosomeEnrichment.GRanges}
\title{A function to compute nucleosome enrichment over a set of GRanges}
\usage{
\method{nucleosomeEnrichment}{GRanges}(x, granges, plus1_nuc_only = FALSE, verbose = TRUE, ...)
}
\arguments{
\item{x}{GRanges, paired-end fragments}

\item{granges}{GRanges, loci to map the fragments onto}

\item{plus1_nuc_only}{Boolean, should compute nucleosome 
enrichment only for +1 nucleosome?}

\item{verbose}{Boolean}

\item{...}{additional parameters}
}
\value{
list
}
\description{
A function to compute nucleosome enrichment over a set of GRanges
}
\examples{
data(bam_test)
data(ce11_proms)
n <- nucleosomeEnrichment(bam_test, ce11_proms)
n$fisher_test
n$plot
}
