% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_topGOdata.R
\name{create_topGOdata}
\alias{create_topGOdata}
\alias{create_topGOdata,ANY,ANY,ANY,gene2GO,character,numeric-method}
\title{Create topGOdata object for enrichment test with topGO package.}
\usage{
create_topGOdata(geneSel, allGenes, geneList = NULL, gene2GO, ont, nodeSize)

\S4method{create_topGOdata}{ANY,ANY,ANY,gene2GO,character,numeric}(geneSel, allGenes, geneList = NULL, gene2GO, ont, nodeSize)
}
\arguments{
\item{geneSel}{genes of interest.}

\item{allGenes}{customized background genes.}

\item{geneList}{logical factor (1: genes of interest, 0: genes background,
and gene identifiants in \code{names}) (default value to NULL).}

\item{gene2GO}{a \code{\link{gene2GO-class}} object created by \code{\link{annotate}} method.}

\item{ont}{the ontology used is "MF" (Molecuar Function), "BP" (Biological Process), or "CC" (Cellular Component).}

\item{nodeSize}{the minimum number of genes for each GO term.}
}
\value{
a  \code{\link[topGO]{topGOdata-class}} object required by \code{runTest} from \pkg{topGO} package.
}
\description{
This method create a \code{\link[topGO]{topGOdata-class}} object required by \pkg{topGO} package in order
to perform GO enrichment test.
}
\details{
This method is a convenient wrapper building a \code{\link[topGO]{topGOdata-class}} object
using a given ontology category (\code{ont} argument) in order to perform GO enrichment test.
The complete GO annotation is required (\code{gene2GO} argument) and also
the list of genes of interest (\code{geneSel} argument) against the corresponding background (\code{allGenes} argument)
separately, or grouped together in a \code{factor} (\code{geneList} argument).
}
\examples{
 # load genes identifiants (GeneID,ENS...) background (Expressed genes)
 background<-scan(
  system.file(
   "extdata/data/input",
   "background_L.txt",
   package = "ViSEAGO"
  ),
  quiet=TRUE,
  what=""
 )

 # load Differentialy Expressed (DE) gene identifiants from files
 pregnantvslactateDE<-scan(
  system.file(
   "extdata/data/input",
   "pregnantvslactateDE.txt",
   package = "ViSEAGO"
 ),
  quiet=TRUE,
  what=""
 )

\dontrun{
# create topGOdata for BP for each list of DE genes
BP_L_pregnantvslactate<-ViSEAGO::create_topGOdata(
 geneSel=pregnantvslactateDE,
 allGenes=background,
 gene2GO=myGENE2GO,
 ont="BP",
 nodeSize=5
)
}
}
\references{
Alexa A, Rahnenfuhrer J, Lengauer T. Improved scoring of functional groups from gene expression data by
decorrelating GO graph structure. Bioinformatics 2006; 22:1600-1607.
}
\seealso{
Other GO_terms: 
\code{\link{GOcount}()},
\code{\link{GOterms_heatmap}()},
\code{\link{annotate}()},
\code{\link{gene2GO-class}},
\code{\link{merge_enrich_terms}()},
\code{\link{runfgsea}()}
}
\concept{GO_terms}
