% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Upset.R
\name{Upset}
\alias{Upset}
\alias{Upset,ANY-method}
\title{Enriched GO terms intersections plot.}
\usage{
Upset(object, file = "./upset.xls")

\S4method{Upset}{ANY}(object, file = "./upset.xls")
}
\arguments{
\item{object}{an \code{\link{enrich_GO_terms-class}} or \code{\link{GO_clusters-class}} objects.}

\item{file}{output file name (default to "./upset.xls")}
}
\value{
print table and upset.
}
\description{
This method allows to visualize GO terms intersections between results of enrichment tests.
}
\details{
This function displays and print the intersections of enriched GO terms (p<0.01) between all results provided by \code{\link{enrich_GO_terms-class}}
or \code{\link{GO_clusters-class}} objects. The intersections are shown in an upset plot and printed in a table.
}
\examples{
# load example object
data(
    myGOs,
    package="ViSEAGO"
)

# print upset
ViSEAGO::Upset(myGOs)
}
\seealso{
Other enrich_GO_terms: 
\code{\link{enrich_GO_terms-class}},
\code{\link{overLapper}()},
\code{\link{show_heatmap}()},
\code{\link{show_table}()}

Other visualization: 
\code{\link{GOclusters_heatmap}()},
\code{\link{GOcount}()},
\code{\link{GOterms_heatmap}()},
\code{\link{available_organisms}()},
\code{\link{overLapper}()},
\code{\link{show_heatmap}()},
\code{\link{show_table}()}
}
\concept{enrich_GO_terms}
\concept{visualization}
