% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R
\name{vennDiagram}
\alias{vennDiagram}
\title{Create a Venn diagram}
\usage{
vennDiagram(
  object,
  fill = NULL,
  alpha = 0.5,
  labels = TRUE,
  counts = TRUE,
  showNumbers = TRUE,
  numberSize = 4,
  numberColor = "black",
  labelSize = 4,
  labelColor = "black",
  borderCol = FALSE,
  fillCol = TRUE,
  fixedCoords = TRUE,
  xlim = c(0, 1),
  ylim = c(0, 1),
  show_percentages = TRUE,
  show_unique_only = FALSE,
  scaled = FALSE,
  title = NULL,
  interactive = FALSE,
  ...
)
}
\arguments{
\item{object}{A Venn object}

\item{fill}{Colors for filling the circles}

\item{alpha}{Transparency level for the circles (0-1)}

\item{labels}{Logical: show set labels? (default: TRUE)}

\item{counts}{Logical: show counts? (default: TRUE)}

\item{showNumbers}{Logical: whether to show counts and percentages in each region}

\item{numberSize}{Size of the count labels}

\item{numberColor}{Color of the count labels}

\item{labelSize}{Size of the set labels}

\item{labelColor}{Color of the set labels}

\item{borderCol}{Logical: whether to color the borders of circles}

\item{fillCol}{Logical: whether to fill circles with colors}

\item{fixedCoords}{Logical: whether to use fixed coordinates}

\item{xlim}{Vector with 2 numbers, x axis limits for the venn diagram}

\item{ylim}{Vector with 2 numbers, y axis limits for the venn diagram}

\item{show_percentages}{Logical: show percentages alongside counts? (default: TRUE)}

\item{show_unique_only}{Logical: show counts only for unique elements? (default: FALSE)}

\item{scaled}{Logical: scale circles by set size? (default: FALSE)}

\item{title}{Optional plot title}

\item{interactive}{Logical: create interactive plot? (default: FALSE)}

\item{...}{Additional arguments passed to ggplot2 functions}
}
\value{
A ggplot2 or plotly object
}
\description{
Creates a traditional Venn diagram for 2-5 sets
}
\author{
Kai Guo
}
