% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interactive.R
\name{vennApp}
\alias{vennApp}
\title{Create an interactive Venn diagram app}
\usage{
vennApp(object, launch = TRUE, ...)
}
\arguments{
\item{object}{A Venn object}

\item{launch}{Launch the app immediately? Default: TRUE}

\item{...}{Additional arguments passed to shiny::runApp}
}
\value{
A Shiny app object (invisibly)
}
\description{
Creates a Shiny app for interactive exploration of Venn diagrams
}
\examples{
\dontrun{
# Create a Venn object
A <- sample(1:100, 40, replace = FALSE)
B <- sample(1:100, 60, replace = FALSE)
C <- sample(1:100, 40, replace = FALSE)
res <- venndetail(list(A = A, B = B, C = C))

# Launch interactive app
vennApp(res)
}
}
\author{
Kai Guo
}
