% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/dplot.R
\docType{methods}
\name{getSet}
\alias{getSet}
\alias{getSet,Venn-method}
\title{Extract specific subsets from a Venn object}
\usage{
getSet(object, subset = NULL, min = 0, wide = FALSE)

\S4method{getSet}{Venn}(object, subset = NULL, min = 0, wide = FALSE)
}
\arguments{
\item{object}{Venn object}

\item{subset}{Character vector giving the subset names}

\item{min}{The minimum number of input groups that a subset must belong to
e.g. min = 2 will only report those
subsets with elements shared by 2 or more input groups.}

\item{wide}{Boolean indicating return wide format (default: FALSE).}
}
\value{
A data.frame with elements from the specified subsets

Specific subset information
}
\description{
Extracts elements from specified subsets

getSet function provides a way to extract subsets from
venndetail object
}
\examples{
A <- sample(1:100, 40, replace = FALSE)
B <- sample(1:100, 60, replace = FALSE)
C <- sample(1:100, 40, replace = FALSE)
res <- venndetail(list(A = A, B = B, C = C))
# Get elements unique to set A
unique_to_A <- getSet(res, "A")
# Get elements shared by all sets
shared <- getSet(res, "Shared")
A <- sample(1:100, 40, replace = FALSE)
B <- sample(1:100, 60, replace = FALSE)
C <- sample(1:100, 40, replace = FALSE)
res <- venndetail(list(A = A, B = B, C = C))
getSet(res, "A")
}
\author{
Kai Guo
}
