% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/venn-diagram.R
\name{.vennDiagram}
\alias{.vennDiagram}
\title{Create a standalone Venn diagram}
\usage{
.vennDiagram(
  setlist,
  title = NULL,
  colors = NULL,
  alpha = 0.4,
  showNumbers = TRUE,
  numberSize = 4,
  numberColor = "black",
  labelSize = 4,
  labelColor = "black",
  borderCol = FALSE,
  fillCol = TRUE,
  fixedCoords = TRUE,
  xlim = c(0, 1),
  ylim = c(0, 1)
)
}
\arguments{
\item{setlist}{A named list of character vectors, each representing a set}

\item{title}{Optional title for the plot}

\item{colors}{Vector of colors for the sets. If NULL, default colors will be used}

\item{alpha}{Transparency level for the circles (0-1)}

\item{showNumbers}{Logical, whether to show counts and percentages in each region}

\item{numberSize}{Size of the count labels}

\item{numberColor}{Color of the count labels}

\item{labelSize}{Size of the set labels}

\item{labelColor}{Color of the set labels}

\item{borderCol}{Logical, whether to color the borders of circles}

\item{fillCol}{Logical, whether to fill circles with colors}

\item{fixedCoords}{Logical, whether to use fixed coordinates}

\item{xlim}{Vector with 2 numbers, x axis limits for the venn diagram}

\item{ylim}{Vector with 2 numbers, y axis limits for the venn diagram}
}
\value{
A ggplot object
}
\description{
This function creates a standalone Venn diagram for 2-5 sets
}
\author{
Kai Guo
}
\keyword{internal}
