% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllClasses.R, R/methods-CopyNumScanParams.R
\docType{class}
\name{CopyNumScanParams-class}
\alias{CopyNumScanParams-class}
\alias{CopyNumScanParams}
\alias{show,CopyNumScanParams-method}
\title{Parameters for parsing source files containing SNP-array processed
data, such as GenomeStudio files for the Illumina platform}
\usage{
CopyNumScanParams(
  cnvar = "Log R Ratio",
  bafvar = "B Allele Freq",
  gtvar = c("Allele1 - AB", "Allele2 - AB"),
  index_genome = integer(),
  select = integer(),
  scale = 1000,
  row.names = 1L
)

\S4method{show}{CopyNumScanParams}(object)
}
\arguments{
\item{cnvar}{length-one character vector providing name of variable for log R ratios}

\item{bafvar}{length-one character vector providing name of variable for B allele frequencies}

\item{gtvar}{length-one character vector providing name of variable for genotype calls}

\item{index_genome}{integer vector indicating which rows of the of
the source files (e.g., GenomeStudio) to keep.  By matching on a sorted GRanges
object containing the feature annotation (see example), the
information on the markers will also be sorted.}

\item{select}{integer vector specifying indicating which columns of the source files to import (see examples)}

\item{scale}{length-one numeric vector for rescaling the raw data
and coercing to class integer. By default, the low-level data will
be scaled and saved on disk as integers.}

\item{row.names}{length-one numeric vector indicating which column
the SNP names are in}

\item{object}{a \code{CopyNumScanParams} object}
}
\description{
Raw SNP array processed files have headers and variable labels that
may depend the software, how the output files was saved, the
software version, and other factors.  The purpose of this container
is to collect the parameters relevant for reading in the source
files for a particular project in a single container.  This may
require some experimentation as the example illustrates.  The
function \code{\link{fread}} in the \code{data.table} package
greatly simplifies this process.
}
\section{Slots}{

\describe{
\item{\code{index_genome}}{an integer vector}

\item{\code{cnvar}}{the column label for the log R ratios}

\item{\code{bafvar}}{the column label for the B allele frequencies}

\item{\code{gtvar}}{the column label(s) for the genotypes}

\item{\code{scale}}{length-one numeric vector indicating how the low-level data
should be scaled prior to saving on disk}

\item{\code{select}}{numeric vector indicating which columns to read}

\item{\code{row.names}}{length-one numeric vector indicating which column
the SNP names are in}
}}

\examples{
CopyNumScanParams() ## empty container
}
\seealso{
\code{\linkS4class{ArrayViews}} \code{\link{parseSourceFile}}
}
