% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VCFArray-methods.R
\docType{methods}
\name{dim,VCFArraySeed-method}
\alias{dim,VCFArraySeed-method}
\alias{dimnames,VCFArraySeed-method}
\alias{vcffile}
\alias{vcffile,VCFArraySeed-method}
\alias{vcffile,VCFArraySeed}
\alias{vcffile,VCFArray}
\alias{rowRanges,VCFArraySeed-method}
\alias{show,VCFArraySeed-method}
\alias{vcffile,VCFArray-method}
\alias{rowRanges,VCFArray-method}
\title{VCFArraySeed or VCFArray related methods, slot getters and setters.}
\usage{
\S4method{dim}{VCFArraySeed}(x)

\S4method{dimnames}{VCFArraySeed}(x)

vcffile(x)

\S4method{vcffile}{VCFArraySeed}(x)

\S4method{rowRanges}{VCFArraySeed}(x)

\S4method{show}{VCFArraySeed}(object)

\S4method{vcffile}{VCFArray}(x)

\S4method{rowRanges}{VCFArray}(x)
}
\arguments{
\item{x}{the \code{VCFArray} or \code{VCFArraySeed} objects.}

\item{object}{the \code{VCFArraySeed} object.}
}
\value{
\code{dim}: the integer vector of dimensions for
    \code{VCFArray} or \code{VCFArraySeed} objects.

\code{dimnames}: the unnamed list of dimension names for
    \code{VCFArray} and \code{VCFArraySeed} objects.

\code{vcffile}: the \code{VcfFile} object corresponding to
    the backend VCF file.
}
\description{
\code{dim}, \code{dimnames}: dimension and dimnames of
    object contained in the VCF file.

\code{vcffile}: extract the \code{VcfFile} object
    corresponding to the backend VCF file.

\code{rowRanges}: extract the \code{rowRanges}
    information from the backend VCF file.
}
\examples{
fl <- system.file("extdata", "chr22.vcf.gz",
                  package="VariantAnnotation")
va <- VCFArray(fl, name = "GT")
dim(va)
dimnames(va)
vcffile(va)
seed(va)
dim(seed(va))
DelayedArray::type(va)
}
