% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{utilities}
\alias{utilities}
\alias{taxname2species}
\alias{taxname2taxid}
\alias{taxname2domain}
\title{Translate UniProt taxon names to scientific names, taxids, or domain
codes}
\usage{
taxname2species(taxname, specfile)

taxname2taxid(taxname, specfile)

taxname2domain(taxname, specfile)
}
\arguments{
\item{taxname}{Character string up to 6 uppercase characters, like HUMAN,
MOUSE, or AERPX. Also works for a vector of such taxon names.}

\item{specfile}{An optional local file where speclist.RData is saved from
UniProt.org.  When \code{specfile} is missing, a cached file from the extdata/
package directory is used.}
}
\value{
\itemize{
\item \code{taxname2species}: a character vector of scientific taxon names
matching to the UniProt taxon names supplied as \code{taxname}.
\itemize{
\item \code{taxname2taxid}: a numeric vector of Taxonomy IDs matching to the
UniProt taxon names supplied as \code{taxname}.
\item \code{taxname2domain}: a character vector of one letter domain
symbols matching to the UniProt taxon names supplied as \code{taxname}.
}
}
}
\description{
UniProt uses custom coding of organism names from which protein
sequences they store. These taxon names are used also in the protein names
(not in the UniProt IDs!). These functions help to translate those names to
standard scientific (Latin) taxon names and other useful identifiers.
\itemize{
\item taxname2species(): converts UniProt taxonomy names to
scientific species names
\item taxname2taxid(): converts UniProt taxonomy names to NCBI Taxonomy IDs
\item taxname2domain(): converts UniProt taxonomy names to the following
taxonomical domains:
\itemize{
\item 'A' for archaea (=archaebacteria)
\item 'B' for bacteria (=prokaryota or eubacteria)
\item 'E' for eukaryota (=eukarya)
\item 'V' for viruses and phages (=viridae)
\item 'O' for others (such as artificial sequences)
}
}
}
\examples{

taxname2species("PIG")
taxname2species(c("PIG","HUMAN","TRIHA"))

taxname2taxid("PIG")
taxname2taxid(c("PIG","HUMAN","TRIHA"))

taxname2domain("PIG")
taxname2domain(c("PIG","HUMAN","TRIHA"))

}
\seealso{
\href{https://www.uniprot.org/docs/speclist.txt}{UniProt controlled vocabulary of species}, which defines the
taxon names.
}
\author{
Csaba Ortutay
}
