% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UniProt.ws-class.R
\docType{class}
\name{UniProt.ws-class}
\alias{UniProt.ws-class}
\alias{.UniProt.ws}
\alias{taxId}
\alias{taxId<-}
\alias{UniProt.ws}
\alias{show,UniProt.ws-method}
\alias{taxId,UniProt.ws-method}
\alias{availableUniprotSpecies}
\alias{lookupUniprotSpeciesFromTaxId}
\alias{taxId<-,UniProt.ws-method}
\alias{species,UniProt.ws-method}
\title{UniProt.ws objects and their related methods and functions}
\usage{
UniProt.ws(taxId = 9606, ...)

\S4method{show}{UniProt.ws}(object)

\S4method{taxId}{UniProt.ws}(x)

availableUniprotSpecies(pattern = "")

lookupUniprotSpeciesFromTaxId(taxId)

\S4method{taxId}{UniProt.ws}(x) <- value

\S4method{species}{UniProt.ws}(object)
}
\arguments{
\item{taxId}{\code{numeric(1)} a taxonomy identifier}

\item{...}{other arguments}

\item{x, object}{a \code{UniProt.ws} object.}

\item{pattern}{character string containing a \link[base]{regular expression}
    (or character string for \code{fixed = TRUE}) to be matched
    in the given character vector.  Coerced by
    \code{\link[base]{as.character}} to a character string if possible.  If a
    character vector of length 2 or more is supplied, the first element
    is used with a warning.  Missing values are allowed except for
    \code{regexpr}, \code{gregexpr} and \code{regexec}.}

\item{value}{\code{numeric(1)} the new taxId to set}
}
\value{
\itemize{
\item \code{species} and \code{lookupUniprotSpeciesFromTaxId} each return a
character vector of possible values
\itemize{
\item \code{taxId} returns a numeric value that corresponds to the taxonomy ID
\item \code{availableUniprotSpecies} returns a \code{data.frame}
}
}
}
\description{
\code{UniProt.ws} is the base class for interacting with the UniProt
web services from Bioconductor.
}
\details{
\code{UniProt.ws} is a class that is used to interact with the UniProt
web services. It makes use of \code{AnnotationDbi} methods similarly to
\code{AnnotationDb} objects.

The \code{UniProt.ws} will be loaded whenever you load the \code{UniProt.ws} package.
This object will be set up to retrieve information from Homo sapiens by
default, but this value can be changed to any of the species supported by
UniProt.  The \code{species} and \code{taxId} methods allow users to see what species
is currently being accessed, and \verb{taxId<-} allows them to change this
value.

\code{species} shows the genus and species label currently attached to the
\code{UniProt.ws} objects database.

\code{taxId} shows the NCBI taxonomy ID currently attached to the \code{AnnotationDb}
objects database.  Using the equivalently names replace method (\verb{taxId<-})
allows the user to change the taxon ID, and the species represented along
with it.

\code{availableUniprotSpecies} is a helper function to list out the available
Species along with their official taxonomy IDs that are available by
UniProt.  Because there are so many species represented at UniProt, there
is also a pattern argument that can be used to restrict the range of things
returned to be only those whose species names match the searth term. Please
remember when using this argument that the Genus is always capitalized and
the species never is.

\code{lookupUniprotSpeciesFromTaxId} is another helper that will look up the
species of any tax ID that is supported by UniProt.
}
\section{Functions}{
\itemize{
\item \code{show(UniProt.ws)}: Show method for UniProt.ws objects

\item \code{taxId(UniProt.ws)}: Get the taxonomy ID from a UniProt.ws object

\item \code{taxId(UniProt.ws) <- value}: Set or chnage the taxonomy ID for a UniProt.ws
object

\item \code{species(UniProt.ws)}: Get the species name from a UniProt.ws object

}}
\examples{

## Make a UniProt.ws object
up <- UniProt.ws(taxId=9606)

## look at the object
up

## get the current species
species(up)

## look up available species with their tax ids
availableUniprotSpecies("musculus")

## get the current taxId
taxId(up)

## look up the species that goes with a tax id
lookupUniprotSpeciesFromTaxId(9606)

## set the taxId to something else
taxId(up) <- 10090
up

}
\seealso{
\link{UniProt.ws-methods}
}
\author{
Marc Carlson
}
