% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/markRecurrentRegions.R
\name{markRecurrentRegions}
\alias{markRecurrentRegions}
\title{Annotate regions as recurrent or non-recurrent}
\usage{
markRecurrentRegions(df, recurrent_regions)
}
\arguments{
\item{df}{Data.frame with region coordinates and sample IDs.}

\item{recurrent_regions}{GRanges object from identifyRecurrentRegions().}
}
\value{
The same data.frame with two added columns:
\itemize{
\item Recurrent: "Yes" or "No"
\item n_samples: Number of supporting samples (if recurrent)
}
}
\description{
Given a results data.frame and a set of recurrent genomic regions,
this function labels each row as "Yes" (recurrent) or "No".
}
\examples{
input <- data.frame(
ID = c("S1", "S2", "S3", "S4"),
seqnames = c("chr1", "chr1", "chr1", "chr2"),
start = c(100, 120, 500, 100),
end = c(150, 170, 550, 150),
n_mendelian_error = c(10, 20, 5, 200)
)

recurrent_gr <- GenomicRanges::GRanges(
 seqnames = "chr1",
 ranges = IRanges::IRanges(
   start = 100,
   end = 170
 ),
 n_samples = 2
)
markRecurrentRegions(input, recurrent_gr)
}
