% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getViewpointCoordinates.R
\name{getViewpointCoordinates}
\alias{getViewpointCoordinates}
\title{Get viewpoint coordinates}
\usage{
getViewpointCoordinates(
  bait_seq,
  bait_pad,
  res_enz,
  ref_gen,
  sel_seqname = NULL
)
}
\arguments{
\item{bait_seq}{Character containing the bait primer sequence.}

\item{bait_pad}{Character containing the pad sequence (sequence between the
bait primer and the restriction enzyme sequence).}

\item{res_enz}{Character containing the restriction enzyme sequence.}

\item{ref_gen}{A BSgenome object of the reference genome.}

\item{sel_seqname}{A character with the chromosome name to focus the
search for the viewpoint sequence.}
}
\value{
Creates a GRanges object containing the genomic position of the
viewpoint.
}
\description{
Finds the viewpoint coordinates for a given reference genome and sequence.
}
\examples{
getViewpointCoordinates(
    bait_seq = "GGACAAGCTCCCTGCAACTCA",
    bait_pad = "GGACTTGCA",
    res_enz = "GATC",
    ref_gen = BSgenome.Hsapiens.UCSC.hg19::BSgenome.Hsapiens.UCSC.hg19,
    sel_seqname = "chr16" # Look only in chr16
)
}
