% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloadUMI4CexampleData.R
\name{downloadUMI4CexampleData}
\alias{downloadUMI4CexampleData}
\title{Download UMI4Cats example datasets}
\usage{
downloadUMI4CexampleData(out_dir = tempdir(), verbose = TRUE, reduced = FALSE)
}
\arguments{
\item{out_dir}{Output directory for the datasets, defaults to tempdir().}

\item{verbose}{Whether to print verbose messages or not. Default: TRUE.}

\item{reduced}{Whether to use a reduced dataset to make test functions run faster.}
}
\value{
It creates the \code{output_dir} with the example UMI-4C files used
 by the vignette and examples. Takes advantage of the BiocFileCache package to
 make sure that the file has not been previously downloaded by the user.
}
\description{
Downloads the required UMI4Cats example datasets.
}
\examples{
if (interactive()) {
 # Using reduced data data to make example faster.
# Remove reduced=TRUE or set to FALSE to
# download the full dataset.

path <- downloadUMI4CexampleData(reduced = TRUE)
}
}
