% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/digestGenome.R
\name{digestGenome}
\alias{digestGenome}
\title{Digest reference genome}
\usage{
digestGenome(
  res_enz,
  cut_pos,
  name_RE,
  ref_gen,
  sel_chr = paste0("chr", c(seq_len(22), "X", "Y")),
  out_path = "digested_genome/"
)
}
\arguments{
\item{res_enz}{Character containing the restriction enzyme sequence.}

\item{cut_pos}{Numeric indicating the nucleotide position where restriction
enzyme cuts (zero-based) (for example, for DpnII is 0).}

\item{name_RE}{Restriction enzyme name.}

\item{ref_gen}{A BSgenome object of the reference genome.}

\item{sel_chr}{Character vector indicating which chromosomes to select for
the digestion. Default: chr1-22, chrX, chrY.}

\item{out_path}{Output path where to save the genomic track. The default is a
 directory named \code{digested_genome/} created in your working directory. The rda
objects are saved in folder named by the \code{ref_gene}_\code{name_RE} in the
\code{out_path} folder.}
}
\value{
Creates a rda file for every chromosome defined in \code{sel_chr}.
}
\description{
Performs an \emph{in silico} digestion of a given reference genome using a
given restriction enzyme sequence.
}
\examples{
library(BSgenome.Hsapiens.UCSC.hg19)
ref_gen <- BSgenome.Hsapiens.UCSC.hg19

hg19_dpnii <- digestGenome(
    res_enz = "GATC",
    cut_pos = 0,
    name_RE = "dpnII",
    sel_chr = "chr16", # Only in chr16 to reduce example running time
    ref_gen = ref_gen,
    out_path = file.path(tempdir(), "digested_genome/")
)
}
