% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/demultiplexFastq.R
\name{demultiplexFastq}
\alias{demultiplexFastq}
\title{Demultiplex FASTQ files using fastq-multx}
\usage{
demultiplexFastq(barcodes, fastq, out_path = "raw_fastq", numb_reads = 1e+11)
}
\arguments{
\item{barcodes}{Dataframe with "name of sample" and "barcode" for every
sample to demultiplex.}

\item{fastq}{Fastq to demultiplex containing mate 1s. Different pairs should
be named as "_R1" or "_R2". Allowed formats: _R1.fastq.gz, _R1.fq.gz, _R1.fastq
or _R1.fq.}

\item{out_path}{Path where to save the demultiplex output. Defaults to a path
named \code{raw_fastq} in your working directory.}

\item{numb_reads}{Number of lines from the FastQ file to load in each loop.
If having memory size problems, change it to a smaller number. Default=10e10.}
}
\value{
Paired-end FastQ files demultiplexed in a compressed format. A log file with the statistics
is also generated in \code{out_path} named \code{barcode}_umi4cats_demultiplexFastq_stats.txt.
}
\description{
Demultiplex FASTQ files containng different bait information
}
\examples{
\dontrun{
path <- downloadUMI4CexampleData(use_sample = TRUE)
fastq <- file.path(path, "CIITA", "fastq", "sub_ctrl_hi19_CIITA_R1.fastq.gz")
barcodes <- data.frame(
    sample = c("CIITA"),
    barcode = c("GGACAAGCTCCCTGCAACTCA")
)

demultiplexFastq(
    barcodes = barcodes,
    fastq = fastq,
    out_path = path
)
}

}
