% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groupUMI4C.R
\name{addGrouping}
\alias{addGrouping}
\title{Add grouping of UMI-4C samples}
\usage{
addGrouping(
  umi4c,
  grouping = "sampleID",
  scales = 5:150,
  normalized = TRUE,
  sd = 2
)
}
\arguments{
\item{umi4c}{\linkS4class{UMI4C} object as generated by \code{\link{makeUMI4C}}.}

\item{grouping}{Name of the column in colData used to merge the samples or
replicates. Set to NULL for skipping grouping. Default: "condition".}

\item{scales}{Numeric vector containing the scales for calculating the
domainogram.}

\item{normalized}{Logical indicating whether UMI-4C profiles should be
normalized to the \code{ref_umi4c} sample/group. Default: TRUE}

\item{sd}{Stantard deviation for adaptative trend.}
}
\value{
Adds a new \code{UMI4C} object into the \code{groupsUMI4C} slot with 
samples grouped according to \code{grouping} variable.
}
\description{
This function can be used to add specific groupings to \code{UMI4C} objects.
}
\examples{
data("ex_ciita_umi4c")

ex_ciita_umi4c <- addGrouping(ex_ciita_umi4c, grouping="condition")
}
