% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_unionLeaf.R
\name{unionLeaf}
\alias{unionLeaf}
\title{list leaf nodes that are the descendants of at least one specified node}
\usage{
unionLeaf(tree, node)
}
\arguments{
\item{tree}{A phylo object.}

\item{node}{A numeric or character vector. It specifies internal nodes that
are changed to leaves via their node labels or numbers.}
}
\value{
A phylo object.
}
\description{
\code{unionLeaf} list the leaf nodes that are the desendants of (at least one)
specified nodes.
}
\examples{
library(ggtree)
data(tinyTree)
ggtree(tinyTree, ladderize = FALSE) +
    geom_text2(aes(label = label), color = "darkorange",
           hjust = -0.1, vjust = -0.7) +
    geom_text2(aes(label = node), color = "darkblue",
               hjust = -0.5, vjust = 0.7) +
    geom_hilight(node = 18) +
    geom_point2()

u1 <- unionLeaf(tree = tinyTree, node = c(19, 17))
u2 <- unionLeaf(tree = tinyTree, node = c(19, 17, 7))
(u3 <- unionLeaf(tree = tinyTree, node = c(11, 17, 7)))
}
