% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_trackNode.R
\name{trackNode}
\alias{trackNode}
\title{track the nodes of a phylo tree}
\usage{
trackNode(tree)
}
\arguments{
\item{tree}{A phylo object}
}
\value{
a phylo object
}
\description{
\code{trackNode} track nodes of a phylo tree by adding the alias labels to
them
}
\examples{
library(ggtree)

data(tinyTree)

ggtree(tinyTree, branch.length = 'none') +
    geom_text2(aes(label = label), hjust = -0.3) +
    geom_text2(aes(label = node), vjust = -0.8,
               hjust = -0.3, color = 'blue')

#check whether the node number and node label are matched
trackTree <- trackNode(tinyTree)
ggtree(trackTree, branch.length = 'none') +
    geom_text2(aes(label = label), hjust = -0.3) +
    geom_text2(aes(label = node), vjust = -0.8,
               hjust = -0.3, color = 'blue')
}
\author{
Ruizhu Huang
}
