% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_findAncestor.R
\name{findAncestor}
\alias{findAncestor}
\title{Find the ancestors of specified nodes}
\usage{
findAncestor(tree, node, level, use.alias = FALSE)
}
\arguments{
\item{tree}{A phylo object}

\item{node}{A vector of node numbers or node labels}

\item{level}{A vector of numbers to define nth generation before the
specified nodes}

\item{use.alias}{A logical value, TRUE or FALSE. The default is FALSE, and
the node label would be used to name the output; otherwise, the alias of
node label would be used to name the output. The alias of node label is
created by adding a prefix \code{"alias_"} to the node number.}
}
\value{
A vector of nodes. The numeric value is the node number, and the
  vector name is the corresponding node label. If a node has no label, it
  would have NA as name when \code{use.alias = FALSE}, and have the alias of
  node label as name when \code{use.alias = TRUE}.
}
\description{
\code{findAncestor} finds the ancestor in the nth generation above
specified nodes.
}
\examples{
library(ggtree)
data(tinyTree)
ggtree(tinyTree, branch.length = 'none') +
 geom_text2(aes(label = label), color = "darkorange",
           hjust = -0.1, vjust = -0.7) +
 geom_text2(aes(label = node), color = "darkblue",
               hjust = -0.5, vjust = 0.7)

 findAncestor(tree = tinyTree, node = c(18, 13), level = 1)
}
\author{
Ruizhu Huang
}
