#' Swiss-Prot MS-GF+ data
#'
#' @description
#' Data from a Pyrococcus furiosis sample run on a LTQ-Orbitrap Velos mass spectrometer.
#' The data can be found in the PRIDE repository with identifier PXD001077.
#' The Pyrococcus furiosis reference proteome fasta files were downloaded from
#' UniProtKB/Swiss-Prot on April 22, 2016.
#' The Pyrococcus data was searched against all Pyrococcus proteins
#' with MS-GF+ search engines using the reference proteome
#' from UniProtKB/Swiss-Prot.
#'
#' @format An \linkS4class{mzID} object.
#'
#' @usage data(ModSwiss)
"ModSwiss"

#' Swiss-Prot X!Tandem data
#'
#' @description
#' Data from a Pyrococcus furiosis sample run on a LTQ-Orbitrap Velos mass spectrometer.
#' The data can be found in the PRIDE repository with identifier PXD001077.
#' The Pyrococcus furiosis reference proteome fasta files were downloaded from
#' UniProtKB/Swiss-Prot on April 22, 2016.
#' The Pyrococcus data was searched against all Pyrococcus proteins
#' with a combined search (omssa, X!Tandem and MS-GF+) using the reference proteome
#' from UniProtKB/Swiss-Prot.
#'
#' @format An \linkS4class{mzID} object.
#'
#' @usage data(ModSwissXT)
"ModSwissXT"
