% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotmclust.R
\name{plotmclust}
\alias{plotmclust}
\title{plotmclust}
\usage{
plotmclust(
  mclustobj,
  x = 1,
  y = 2,
  MSTorder = NULL,
  show_tree = T,
  show_cell_names = T,
  cell_name_size = 3,
  markerexpr = NULL
)
}
\arguments{
\item{mclustobj}{The exact output of \code{\link{exprmclust}} function.}

\item{x}{The column of data after dimension reduction to be plotted on the horizontal axis.}

\item{y}{The column of data after dimension reduction to be plotted on the vertical axis.}

\item{MSTorder}{The arbitrary order of cluster to be shown on the plot.}

\item{show_tree}{Whether to show the links between cells connected in the minimum spanning tree.}

\item{show_cell_names}{Whether to draw the name of each cell in the plot.}

\item{cell_name_size}{The size of cell name labels if show_cell_names is TRUE.}

\item{markerexpr}{The gene expression used to define the size of nodes.}
}
\value{
A ggplot2 object.
}
\description{
Plot the model-based clustering results
}
\details{
This function will plot the gene expression data after dimension reduction and show the clustering results.
}
\examples{
data(lpsdata)
procdata <- preprocess(lpsdata)
lpsmclust <- exprmclust(procdata)
plotmclust(lpsmclust)
}
\author{
Zhicheng Ji, Hongkai Ji <zji4@zji4.edu>
}
