% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_funcs.R
\name{plot2dTppFcHeatmap}
\alias{plot2dTppFcHeatmap}
\title{Plot heatmap of 2D thermal profile fold changes of 
a protein of choice}
\usage{
plot2dTppFcHeatmap(df, name, drug_name = "", midpoint = 1)
}
\arguments{
\item{df}{tidy data frame of a 2D-TPP dataset}

\item{name}{gene name (clustername) of protein that 
should be visualized}

\item{drug_name}{character string of profiled drug name}

\item{midpoint}{midpoint of fold changes for color
scaling, default: 1}
}
\value{
A ggplot displaying the thermal profile 
as a heatmap of fold changes of
a protein of choice in a dataset of choice
}
\description{
Plot heatmap of 2D thermal profile fold changes of 
a protein of choice
}
\examples{

data("simulated_cell_extract_df")
plot2dTppFcHeatmap(simulated_cell_extract_df, 
 "tp2", drug_name = "drug1")

}
