% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_funcs.R
\name{gg_qq}
\alias{gg_qq}
\title{Plot qq-plot of true data and bootstrapped null with ggplot}
\usage{
gg_qq(
  x,
  y,
  xlab = "F-statistics from sampled Null distr.",
  ylab = "observed F-statistics",
  alpha = 0.25,
  gg_theme = theme_classic(),
  offset = 1,
  plot_diagonal = TRUE
)
}
\arguments{
\item{x}{vector containing values of values of first 
distribution to compare}

\item{y}{vector containing values of values of secound 
distribution to compare}

\item{xlab}{x-axis label}

\item{ylab}{y-axis label}

\item{alpha}{transparency paramenter between 0 and 1}

\item{gg_theme}{ggplot theme, default is theme_classic()}

\item{offset}{offset for x and y axis on top of maximal 
values}

\item{plot_diagonal}{logical parameter indicating whether
an identity line should be plotted}
}
\value{
A ggplot displaying the qq-plot of a true and a
a bootstrapped null distribution
}
\description{
Plot qq-plot of true data and bootstrapped null with ggplot
}
\examples{

data("simulated_cell_extract_df")
recomputeSignalFromRatios(simulated_cell_extract_df)

}
