% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fdr_funcs.R
\name{getFDR}
\alias{getFDR}
\title{Get FDR for given F statistics based on true and
null dataset}
\usage{
getFDR(df_out, df_null, squeezeDenominator = TRUE)
}
\arguments{
\item{df_out}{data frame containing results from analysis by
fitAndEvalDataset}

\item{df_null}{data frame containing results from analysis by
bootstrapNull}

\item{squeezeDenominator}{logical indicating whether F statistic
denominator should be shrinked using limma::squeezeVar}
}
\value{
data frame annotating each protein with a FDR based on 
it's F statistic and number of observations
}
\description{
Get FDR for given F statistics based on true and
null dataset
}
\examples{
data("simulated_cell_extract_df")
temp_df <- simulated_cell_extract_df \%>\% 
  filter(clustername \%in\% paste0("protein", 1:5)) \%>\% 
  group_by(representative) \%>\% 
  mutate(nObs = n()) \%>\% 
  ungroup 
example_out <- fitAndEvalDataset(temp_df)
example_null <- bootstrapNull(temp_df, B = 1)
getFDR(example_out, example_null)
 
}
