% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perform_analysis.R
\name{fitH1Model}
\alias{fitH1Model}
\title{Fit H1 model and evaluate fit statistics}
\usage{
fitH1Model(
  df,
  maxit = 500,
  optim_fun = .min_RSS_h1_slope_pEC50,
  optim_fun_2 = NULL,
  gr_fun = NULL,
  gr_fun_2 = NULL,
  ec50_lower_limit = NULL,
  ec50_upper_limit = NULL,
  slopEC50 = TRUE
)
}
\arguments{
\item{df}{tidy data_frame retrieved after import of a 2D-TPP 
dataset, potential filtering and addition of a column "nObs"
containing the number of observations per protein}

\item{maxit}{maximal number of iterations the optimization
should be given, default is set to 500}

\item{optim_fun}{optimization function that should be used
for fitting the H0 model}

\item{optim_fun_2}{optional secound optimization function for
fitting the H1 model that should be used based on the fitted 
parameters of the optimizationfor based on optim_fun}

\item{gr_fun}{optional gradient function for optim_fun,
default is NULL}

\item{gr_fun_2}{optional gradient function for optim_fun_2,
default is NULL}

\item{ec50_lower_limit}{lower limit of ec50 parameter}

\item{ec50_upper_limit}{lower limit of ec50 parameter}

\item{slopEC50}{logical flag indicating whether the h1 model is
fitted with a linear model describing the shift od the pEC50 over 
temperatures}
}
\value{
data frame with H1 model characteristics for each
protein
}
\description{
Fit H1 model and evaluate fit statistics
}
\examples{

data("simulated_cell_extract_df")
temp_df <- simulated_cell_extract_df \%>\% 
  filter(clustername \%in\% paste0("protein", 1:5)) \%>\% 
  group_by(representative) \%>\% 
  mutate(nObs = n()) \%>\% 
  ungroup
  
fitH1Model(temp_df)

}
