% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perform_analysis.R
\name{computeFstat}
\alias{computeFstat}
\title{Compute F statistic from H1 and H0 model characteristics}
\usage{
computeFstat(h0_df, h1_df)
}
\arguments{
\item{h0_df}{data frame with H0 model characteristics for each
protein}

\item{h1_df}{data frame with H1 model characteristics for each
protein}
}
\value{
data frame with H0 and H1 model characteristics for each
protein and respectively computed F statistics
}
\description{
Compute F statistic from H1 and H0 model characteristics
}
\examples{
data("simulated_cell_extract_df")
temp_df <- simulated_cell_extract_df \%>\% 
  filter(clustername \%in\% paste0("protein", 1:20)) \%>\% 
  group_by(representative) \%>\% 
  mutate(nObs = n()) \%>\% 
  ungroup 
  
h0_df <- fitH0Model(temp_df)
h1_df <- fitH1Model(temp_df)
  
computeFstat(h0_df, h1_df)

}
