% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perform_analysis.R
\name{competeModels}
\alias{competeModels}
\title{Compete H0 and H1 models per protein and obtain F statistic}
\usage{
competeModels(
  df,
  fcThres = 1.5,
  independentFiltering = FALSE,
  minObs = 20,
  optim_fun_h0 = .min_RSS_h0,
  optim_fun_h1 = .min_RSS_h1_slope_pEC50,
  optim_fun_h1_2 = NULL,
  gr_fun_h0 = NULL,
  gr_fun_h1 = NULL,
  gr_fun_h1_2 = NULL,
  maxit = 750
)
}
\arguments{
\item{df}{tidy data frame retrieved after import of a 2D-TPP 
dataset, potential filtering and addition of a column "nObs"
containing the number of observations per protein}

\item{fcThres}{numeric value of minimal fold change 
(or inverse fold change) a protein has to show to be kept 
upon independent filtering}

\item{independentFiltering}{boolean flag indicating whether
independent filtering should be performed based on minimal
fold changes per protein profile}

\item{minObs}{numeric value of minimal number of observations
that should be required per protein}

\item{optim_fun_h0}{optimization function that should be used
for fitting the H0 model}

\item{optim_fun_h1}{optimization function that should be used
for fitting the H1 model}

\item{optim_fun_h1_2}{optional additional optimization function 
that will be run with paramters retrieved from optim_fun_h1 and 
should be used for fitting the H1 model with the trimmed sum
model, default is NULL}

\item{gr_fun_h0}{optional gradient function for optim_fun_h0,
default is NULL}

\item{gr_fun_h1}{optional gradient function for optim_fun_h1,
default is NULL}

\item{gr_fun_h1_2}{optional gradient function for optim_fun_h1_2,
default is NULL}

\item{maxit}{maximal number of iterations the optimization
should be given, default is set to 500}
}
\value{
data frame summarising the fit characteristics of H0 and
H1 models and therof resulting computed F statistics per protein
}
\description{
Compete H0 and H1 models per protein and obtain F statistic
}
\examples{
data("simulated_cell_extract_df")
temp_df <- simulated_cell_extract_df \%>\% 
  filter(clustername \%in\% paste0("protein", 1:10)) \%>\% 
  group_by(representative) \%>\% 
  mutate(nObs = n()) \%>\% 
  ungroup 
competeModels(temp_df)  

}
