% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/external_TMixClust.R
\name{get_time_series_df_bio}
\alias{get_time_series_df_bio}
\title{Extracts a time series data frame from a Bioconductor Biobase
ExpressionSet object.}
\usage{
get_time_series_df_bio(bio_obj)
}
\arguments{
\item{bio_obj}{Bioconductor Biobase ExpressionSet object. The assayData has
to contain a matrix where each row is a gene time series and each column
contains the time series values at each time point. The number of columns is
equal to the number of time points, while the number of rows is equal to the
number of genes.}
}
\value{
A data frame containing the time series
}
\description{
\code{get_time_series_df_bio} creates a data frame with time
series data from a Bioconductor Biobase ExpressionSet object.
}
\examples{
# Load the SOS pathway data from Bioconductor package SPEM
library(SPEM)
data(sos)
sos_data = get_time_series_df_bio(sos)

# Print the first lines of the retrieved time series data frame
print(head(sos_data))

}
\references{
Golumbeanu M, Desfarges S, Hernandez C, Quadroni M, Rato S,
Mohammadi P, Telenti A, Beerenwinkel N, Ciuffi A. (2017) Dynamics of
Proteo-Transcriptomic Response to HIV-1 Infection.
}
\author{
Monica Golumbeanu, \email{monica.golumbeanu@bsse.ethz.ch}
}
