% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/external_TMixClust.R
\name{generate_TMixClust_report}
\alias{generate_TMixClust_report}
\title{Generates a series of files containing a summary of the TMixClust
analysis results}
\usage{
generate_TMixClust_report(TMixClust_object, report_folder = paste(getwd(),
  "/TMixClust_report/", sep = ""), data_color = "#fd8d3c", x_label = "time",
  y_label = "value")
}
\arguments{
\item{TMixClust_object}{list object created by the \code{TMixClust}
function (see function \code{TMixClust})}

\item{report_folder}{full path of the folder where the report files will
be saved. Default is TMixClust_report/ folder in current working directory.}

\item{data_color}{color of the time series to be used when generating the
cluster plots. Default is orange.}

\item{x_label}{label of the x axis for the cluster plots. Default is "time"}

\item{y_label}{label of the y axis for the cluster plots. Default is "value"}
}
\value{
Produces a series of files containing information about the
clustering results and saves them in the provided folder location.
The folder contains the following:
\itemize{
\item \code{log-lihelihood.txt} - file with the log likelihood values at
each iteration on separate lines
\item \code{log-likelihood.pdf} - plot of log-likelihood at each iteration
\item \code{posterior.txt} - file with the posterior probabilities of all
the time-series for each cluster
\item \code{estimated_curves/} - folder containing a number of files equal to
the number of clusters; each file has 4 lines consisting of curve values and
 their confidence intervals (first 3 lines) for a discrete time grid
 (last line).
\item \code{clusters/} - folder containing a plot with the time series in
each cluster, a silhouette plot of the clustering configuration, as well as,
for each cluster, a file containing the names of the time series in the
respective cluster and a file containing the names and time series values
for the time series in each cluster.
}
}
\description{
\code{generate_TMixClust_report}
}
\examples{
\dontrun{
# Load the toy time series data provided with the TMixClust package
data(toy_data_df)

# Cluster the toy data with default parameters
TMixClust_obj = TMixClust(toy_data_df)

# Generate a TMixClust report in the current working directory
generate_TMixClust_report(TMixClust_obj)
}

}
\references{
Golumbeanu M, Desfarges S, Hernandez C, Quadroni M, Rato S,
Mohammadi P, Telenti A, Beerenwinkel N, Ciuffi A. (2017) Dynamics of
Proteo-Transcriptomic Response to HIV-1 Infection.
}
\author{
Monica Golumbeanu, \email{monica.golumbeanu@bsse.ethz.ch}
}
