% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/invertSets.R
\name{invertSets}
\alias{invertSets}
\alias{invertSets,GeneSet-method}
\alias{invertSets,GeneSetCollection-method}
\title{Invert a List of Sets, Transposing Sets and Elements}
\usage{
invertSets(x, ...)

\S4method{invertSets}{GeneSet}(x, ...)

\S4method{invertSets}{GeneSetCollection}(x, ...)
}
\arguments{
\item{x}{a named list of sets. Elements must be of type \code{"character"}.}

\item{...}{additional arguments are not currently used.}
}
\value{
A named list of sets.
}
\description{
Invert a list of sets so that elements become set names and set
names become elements.
}
\note{
This function is essentially a more limited version of
\code{purrr::transpose_list}.
}
\examples{
x <- list("A" = c("a", "b", "c"),
          "B" = c("c", "d"),
          "C" = c("x", "y", "z"),
          "D" = c("a", "c", "d"))

# Invert sets
(y <- invertSets(x))

# Jaccard similarity of pairs of elements
similarity(y)

# Decompose sets into disjoint parts
yc <- lapply(y, paste, collapse = ", ")
invertSets(yc)
}
