% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genemodel2.R
\name{genemodForGviz}
\alias{genemodForGviz}
\title{create a GeneRegionTrack instance for selected symbols}
\usage{
genemodForGviz(
  sym = "ORMDL3",
  id_elem = c("symbol", "tx_id"),
  resource = EnsDb.Hsapiens.v75::EnsDb.Hsapiens.v75,
  ...
)
}
\arguments{
\item{sym}{character vector of gene symbols, should be neighboring genes}

\item{id_elem}{vector of names of columns generated by genemodelDF to be
used to label transcripts}

\item{resource}{should be or inherit from EnsDb,
answering exons(), with AnnotationFilter::SymbolFilter
as filter parameter}

\item{\dots}{passed to genemodelDF}
}
\value{
instance of Gviz GeneRegionTrack
}
\description{
create a GeneRegionTrack instance for selected symbols
}
\note{
This function helps to display the locations of TF binding sites
in the context of complex gene models.  A complication is that we
have nice visualization of quantitative affinity predictions for TFs
in the vignette, based on ggplot2, but it is not clear how to use
that specific code to work with Gviz.
}
\examples{
if (requireNamespace("EnsDb.Hsapiens.v75") &
    requireNamespace("Gviz")) {
 orm = genemodForGviz("ORMDL3", resource= EnsDb.Hsapiens.v75::EnsDb.Hsapiens.v75)
 orm
 Gviz::plotTracks(orm, showId=TRUE) # change id_elem for shorter id string
}
}
