% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/step6DNAMethylationSitesPerGeneTabulation.R
\name{step6DNAMethylationSitesPerGeneTabulation}
\alias{step6DNAMethylationSitesPerGeneTabulation}
\title{Tabulate the total number of RE DNA methylation sites linked to each gene}
\usage{
step6DNAMethylationSitesPerGeneTabulation(
  TENETMultiAssayExperiment,
  geneAnnotationDataset = NA,
  hypermethGplusAnalysis = TRUE,
  hypomethGplusAnalysis = TRUE
)
}
\arguments{
\item{TENETMultiAssayExperiment}{Specify a MultiAssayExperiment object
containing expression and methylation SummarizedExperiment objects, such
as one created by the TCGADownloader function. The object's metadata must
contain the results from the \code{step5OptimizeLinks} function.}

\item{geneAnnotationDataset}{Specify a gene annotation dataset which is
used to identify names for genes by their Ensembl IDs. The argument must be
either a GRanges object (such as one imported via \code{rtracklayer::import}) or a
path to a GFF3 or GTF file. Both GENCODE and Ensembl annotations are
supported. Other annotation datasets may work, but have not been tested.
See the "Input data" section of the vignette for information on the required
dataset format.
Specify NA to use the gene names listed in the "geneName" column of the
elementMetadata of the rowRanges of the "expression" SummarizedExperiment
object within the TENETMultiAssayExperiment object. Defaults to NA.}

\item{hypermethGplusAnalysis}{Set to TRUE to calculate total links per
gene for hypermethylated RE DNA methylation sites with G+ links. Defaults to
TRUE.}

\item{hypomethGplusAnalysis}{Set to TRUE to calculate total links per
gene for hypomethylated RE DNA methylation sites with G+ links. Defaults to
TRUE.}
}
\value{
Returns the MultiAssayExperiment object given as the
TENETMultiAssayExperiment argument with an additional list named
"step6DNAMethylationSitesPerGeneTabulation" in its metadata containing the
output of this function. This list contains \code{hypermethGplus} and/or
\code{hypomethGplus} data frames, as selected by the user, containing significant
hyper- or hypomethylated G+ link counts per gene.
}
\description{
This function takes the final optimized RE DNA methylation site-gene links
identified in step 5 and tabulates the number of links per gene separately
for the hyper- and/or hypomethylated G+ analysis quadrants.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
## This example uses the example MultiAssayExperiment provided in the
## TENET.ExperimentHub package to tabulate both hyper- and hypomethylated G+
## RE DNA methylation site-gene links, using gene names from the input
## MultiAssayExperiment object.

## Load the example TENET MultiAssayExperiment object
## from the TENET.ExperimentHub package
exampleTENETMultiAssayExperiment <-
    TENET.ExperimentHub::exampleTENETMultiAssayExperiment()

## Calculate linked RE DNA methylation sites per gene
returnValue <- step6DNAMethylationSitesPerGeneTabulation(
    TENETMultiAssayExperiment = exampleTENETMultiAssayExperiment
)

## This example is similar, but only analyzes hypomethylated RE DNA
## methylation sites.

## Load the example TENET MultiAssayExperiment object
## from the TENET.ExperimentHub package
exampleTENETMultiAssayExperiment <-
    TENET.ExperimentHub::exampleTENETMultiAssayExperiment()

## Calculate linked RE DNA methylation sites per gene
returnValue <- step6DNAMethylationSitesPerGeneTabulation(
    TENETMultiAssayExperiment = exampleTENETMultiAssayExperiment,
    hypermethGplusAnalysis = FALSE
)
\dontshow{\}) # examplesIf}
}
