% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corrOrthologTE.R
\name{corrOrthologTE}
\alias{corrOrthologTE}
\title{Estimate correlation comparing orthologs and TEs}
\usage{
corrOrthologTE(geneInput, teInput, corrMethod = "pearson", 
padjMethod = "fdr", numCore=1, fileDir=NULL, 
fileName="TEKRABber_geneTECorrResult.csv")
}
\arguments{
\item{geneInput}{gene count input for correlation from using DECorrInputs()}

\item{teInput}{te count input for correlation from using DECorrInputs()}

\item{corrMethod}{correlation method, including pearson, kendall, spearman. 
Default is pearson.}

\item{padjMethod}{method to return adjusted p-value, and default is fdr. 
See ?p.adjust}

\item{numCore}{number of cores to run parallel. Default is 1. You can use 
detectCores() to get how many cores you can use.}

\item{fileDir}{the name of directory for saving output files. 
Default is NULL.}

\item{fileName}{the name for saving output files. 
Default is "TEKRABber_geneTECorrResult.csv"}
}
\value{
a dataframe includes correlation coefficient, pvalue, padj
}
\description{
To estimate correlation comparing orthologs and TEs one-by-one 
from inputs. You can specify the correlation and adjusted p-value methods 
(see details in parameters). If you want to save your outputs instead of 
just returning them, please specify the fileDir and fileName with the 
extension .csv. The default fileName is TEKRABber_geneTECorrReusult.csv.
}
\examples{
data(ctInputDE)
geneInputDE <- ctInputDE$gene
teInputDE <- ctInputDE$te

metaExp <- data.frame(experiment = c(rep("control", 5), rep("treatment", 5)))
rownames(metaExp) <- colnames(geneInputDE)
metaExp$experiment <- factor(
    metaExp$experiment, 
    levels = c("control", "treatment")
)

resultDE <- DEgeneTE(
    geneTable = geneInputDE,
    teTable = teInputDE,
    metadata = metaExp,
    expDesign = FALSE
)

controlCorr <- corrOrthologTE(
    geneInput = resultDE$geneCorrInputRef[c(1:10),],
    teInput = resultDE$teCorrInputRef[c(1:10),],
    numCore = 1,
    corrMethod = "pearson",
    padjMethod = "fdr"
)

}
