% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blast_primers.R
\name{get_gt_sequences}
\alias{get_gt_sequences}
\title{Get genome and transcriptome sequences}
\usage{
get_gt_sequences(
  genome,
  annot = NULL,
  tx_id = "transcript_id",
  tx_name = "transcript_name",
  gene_name = "gene_name",
  gene_id = "gene_id",
  include_genome = TRUE,
  standard_chromosomes = TRUE
)
}
\arguments{
\item{genome}{A \code{\link[BSgenome:BSgenome-class]{BSgenome}} (or
\code{\link[Biostrings:XStringSet-class]{DNAStringSet}}) object containing the chromosome
sequences to obtain genome and / or transcript sequences.}

\item{annot}{A \code{\link[GenomicRanges:GRanges-class]{GRanges}} object containing all exons of
transcripts to be considered. If not specified, no transcript sequences will be included in the
output fasta file.}

\item{tx_id, tx_name, gene_name, gene_id}{(character) Column names in annot metadata containing
transcript id, transcript name, gene name and gene id information. These column are mandatory,
but can contain internal names (e.g. "transcript-1" or "gene-1").}

\item{include_genome}{(logical) Specifies whether the genome sequence should be included in the
output fasta file.}

\item{standard_chromosomes}{(logical) Specifies whether only standard chromosomes should be
included in output genome sequences (e.g. chr1-22, chrX, chrY, chrM for homo sapiens).}

\item{compress}{(logical) Create a gzipped output fasta file.}
}
\value{
A \code{\link[Biostrings:XStringSet-class]{DNAStringSet}} object containing the genome
  and transcriptome sequences.
}
\description{
Get DNA sequences of all chromosomes and all annotated transcripts of a genome. This function is
used to create the sequences in \code{\link[TAPseq:estimateOffTargets]{createBLASTDb}}.
}
\keyword{internal}
