% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seq_random.R
\name{seq_random}
\alias{seq_random}
\alias{seq_random,numeric,numeric-method}
\title{Generate \code{n} random DNA sequnces of length \code{m}}
\usage{
seq_random(n = 1, m, no.stop.codon = FALSE, ...)

\S4method{seq_random}{numeric,numeric}(n, m, no.stop.codon)
}
\arguments{
\item{n}{the number of the output sequence(s).}

\item{m}{the length of the ouput sequence(s). Eighter a fixed number or a
vector of different numbers.}

\item{no.stop.codon}{Default FALSE. If TRUE, the stop codons in the frame 1
would be substituted to another random codon.}

\item{...}{...}
}
\value{
a DNAStringSet object
}
\description{
Generate \code{n} random DNA sequnces of length \code{m}, optional exclude
stop codons.
}
\examples{
seq_random(n = 1, m = 99)
seq_random(n = 10, m = 30)
seq_random(n = 10, m = 1:10)
seq.nsc <- seq_random(n = 10, m = 100, no.stop.codon = TRUE)
get_cu(seq.nsc)
}
