% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/codon_random.R
\name{codon_random}
\alias{codon_random}
\alias{codon_random,regioned_dna-method}
\alias{codon_random,DNAStringSet-method}
\title{Generate random synonymous mutations}
\usage{
codon_random(object, n = 1, keep = FALSE, numcode = 1, ...)

\S4method{codon_random}{regioned_dna}(object, n, keep, numcode)

\S4method{codon_random}{DNAStringSet}(object, n, keep, numcode)
}
\arguments{
\item{object}{A regioned_dna object.}

\item{n}{Optional n parameter specifying what proportion of the codons to be
mutated. Default value: \code{1}.}

\item{keep}{Logical parameter controling whether keeping the codon usage bias}

\item{numcode}{The ncbi genetic code number for translation. Default value: \code{1}. Details please refer to \code{?seqinr::translate} ("https://rdrr.io/cran/seqinr/man/translate.html").}

\item{...}{...}
}
\value{
A regioned_dna object containing the mutants; Or a DNAStringSet
  object if the input is a DNAStringSet object.
}
\description{
Generating random synonymous mutations (in user-defined region), with
optionally keeping/not keeping the original codon usage bias.
}
\details{
This method randomly sample synonymous codons for \code{n} propotion
  of every mutable codons in the sequences. This process will be likely to
  alter the codon usage bias of the original sequences. However the
  \code{keep = TRUE} argument help to preserve the codon usage bias. It is
  done via the \code{synsequence} function in \code{seqinr} package. The
  \code{synsequence} function essentially swaps the position of the
  synonymous codons without introducing new codons into the original
  sequences.
}
\examples{
filepath <- system.file("extdata", "example.fasta", package = "SynMut")
rgd.seq <- input_seq(filepath)
set.seed(2019)
get_cu(codon_random(rgd.seq, n = 0.5))
get_cu(codon_random(rgd.seq))
}
\seealso{
\code{\link{input_seq}}, \code{\link{dinu_to}},
  \code{\link{codon_to}}, \code{\link{codon_mimic}}
}
