% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Enrichment.R
\name{enrichr}
\alias{enrichr}
\title{Gene enrichment using Enrichr}
\usage{
enrichr(genes, databases)
}
\arguments{
\item{genes}{(Required). Character vector of Entrez gene symbols as input. A data.frame
of gene symbols in first column is also acceptable, optionally a score denoting the
degree of membership between 0 and 1 in the second column.}

\item{databases}{(Required). Character vector of databases to search.
See https://maayanlab.cloud/Enrichr/ for available databases.}
}
\value{
Returns a list of data.frame of enrichment terms, p-values, ...
}
\description{
Gene enrichment using Enrichr
}
\details{
Gene enrichment using Enrichr, slighthly modified by Aurora Maurizio.
}
\examples{
\dontrun{
GeneID  = c("MEST", "CDK1", "PCLAF", "BIRC5")
dbs <- c("GO_Molecular_Function_2023", "GO_Cellular_Component_2023",
         "GO_Biological_Process_2023")
enriched1 <- enrichr(GeneID, dbs)
print(head(enriched1[[1]]))}
}
\author{
Wajid Jawaid \email{wj241@alumni.cam.ac.uk}
}
