% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine_fisher_invnorm.R
\name{combine_fisher_invnorm}
\alias{combine_fisher_invnorm}
\title{combine_fisher_invnorm}
\usage{
combine_fisher_invnorm(
  ind_deg,
  invnorm,
  fishercomb,
  adjpval = 0.05,
  output_tsv = TRUE,
  output_filename = "combine_fisher_invnorm.tsv"
)
}
\arguments{
\item{ind_deg}{List of indipendent DEG dataframes with p-values to be combined.}

\item{invnorm}{inverse normal p-value combination technique dataframe (output of metaRNAseq)}

\item{fishercomb}{Fisher p-value combination technique dataframe (output of metaRNAseq)}

\item{adjpval}{threshold to represent as binary the Meta-Analysis output adjpval.}

\item{output_tsv}{logical. If TRUE, it outputs table with results. Default: TRUE}

\item{output_filename}{File name for the results file.}
}
\value{
A dataframe with \code{DEindices} and \code{DEname} of DEG at the chosen Benjamini Hochberg threshold, and
\code{TestStatistic}, \code{rawpval}, \code{adjpval}, \code{binaryadjpval} vectors for differential expression in the meta-analysis.
}
\description{
Combine Meta-Analysis results with individual DE tables
}
\examples{
\dontrun{
# Deseq2 output samples
DGE1 <- data.frame(GeneID = c("DLK1", "EPCAM"),
                 Mean_CPM_T = c(5.92, 9.91),
                 Mean_CPM_C = c(0.04, 0.03),
                 log2FoldChange = c(10.22, 8.42),
                 lfcSE = c(0.80, 0.48),
                 stat = c(12.68, 17.69),
                 pvalue = c(7.30135e-37, 4.37011e-70),
                 padj = c(1.49936e-35, 1.12976e-67),
                 row.names = c("DLK1", "EPCAM"))
DGE2 <- data.frame(GeneID = c("DLK1", "EPCAM"),
                 Mean_CPM_T = c(3.92, 8.91),
                 Mean_CPM_C = c(0.04, 0.03),
                 log2FoldChange = c(7.22, 5.81),
                 lfcSE = c(0.80, 0.48),
                 stat = c(12.68, 17.69),
                 pvalue = c(7.30135e-37, 4.37011e-70),
                 padj = c(1.49936e-35, 1.12976e-67),
                 row.names = c("DLK1", "EPCAM"))
# input list
ind_deg <- list(DEG1_df = DGE1, DEG2_df = DGE2)
# perform invnorm meta-analysis
invnorm <- metaRNAseq(ind_deg, test_statistic = "invnorm", BHth = 0.05, nrep = c(2,2))
# perform fishercomb meta-analysis
fishercomb <- metaRNAseq(ind_deg, test_statistic = "fishercomb", BHth = 0.05)
# combine results
comb_pval_df <- combine_fisher_invnorm(ind_deg,
                                      invnorm, fishercomb,
                                      adjpval = 0.05,
                                      output_tsv = FALSE)}
}
\seealso{
\code{\link{DGE}} function for DGE analysis,
and \url{https://cran.r-project.org/web/packages/metaRNASeq/vignettes/metaRNASeq.pdf}
for metaRNASeq package info

Other meta-analysis functions: 
\code{\link{metaRNAseq}()}
}
\concept{meta-analysis functions}
