% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/candidateRelocatedProteins.R
\name{candidateRelocatedProteins}
\alias{candidateRelocatedProteins}
\title{Identify candidate relocated proteins}
\usage{
candidateRelocatedProteins(
  sampleCls1,
  s1PSM,
  s1Quant,
  sampleCls2,
  s2PSM,
  s2Quant,
  annotation = FALSE,
  min.psm = 2,
  pearson.cor = 0.8
)
}
\arguments{
\item{sampleCls1}{data.frame; merged classification,
combination of compartment and neighborhood classification.}

\item{s1PSM}{data.frame; minimum PSM count table
across ten TMT channel}

\item{s1Quant}{data.frame; fractionation quantification data}

\item{sampleCls2}{data.frame; merged classification,
combination of compartment and neighborhood classification.}

\item{s2PSM}{data.frame; minimum PSM count table
across ten TMT channel}

\item{s2Quant}{data.frame; fractionation quantification data}

\item{annotation}{boolean; labeling the selected proteins}

\item{min.psm}{numeric; minimum psm, peptide spectra matching value}

\item{pearson.cor}{numeric; pearson correlation threshold}
}
\value{
candidate.df
}
\description{
Identify candidate condition-dependent
relocated proteins by comparing neighborhood classifications
with respect to protein-protein pearson correlation and minumum PSM,
peptide spectrum matching, count.
}
\examples{
{

candidate.df <- candidateRelocatedProteins(hcc827GEFClass, hcc827GefPSMCount,
hcc827GEF, hcc827GEFClass, hcc827GefPSMCount, hcc827GEF,
annotation = FALSE)


}
}
