% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/applyThresholdToNeighborhood.R
\name{applyThresholdNeighborhood}
\alias{applyThresholdNeighborhood}
\title{Apply thresholds to neighborhood classification}
\usage{
applyThresholdNeighborhood(all.repA, all.repB, threshold.df)
}
\arguments{
\item{all.repA}{data.frame; all predictions and probablity vectors
for each protein in replicate A}

\item{all.repB}{data.frame; all predictions and probablity vectors
for each protein in replicate B}

\item{threshold.df}{data.frame; collection od precision and recall
values for each neighborhood}
}
\value{
n.cls.df
}
\description{
Apply thresholds for all predictions at the
neighborhood level to increase the
true positive rate and remove poor classification.
}
\examples{
{

df <- loadData(SubCellBarCode::hcc827Ctrl)

c.prots <- calculateCoveredProtein(rownames(df), markerProteins[,1])

set.seed(7)
c.prots <- sample(c.prots, 600)
cls <- svmClassification(c.prots, df, markerProteins)

test.A <- cls[[1]]$svm.test.prob.out
test.B <- cls[[2]]$svm.test.prob.out

t.n.df <- computeThresholdNeighborhood(test.A, test.B)

all.A <- cls[[1]]$all.prot.pred
all.B <- cls[[2]]$all.prot.pred

n.cls.df <- applyThresholdNeighborhood(all.A, all.B, t.n.df)
}
}
