% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_signature.R
\name{create_signature}
\alias{create_signature}
\title{Create scRNAseq Signature}
\usage{
create_signature(scRNAseq, hvg_genes = FALSE, n_hvg_genes = 3000L, labels)
}
\arguments{
\item{scRNAseq}{SingleCellExperiment object of which to make signature}

\item{hvg_genes}{boolean which chooses if mu and omega should be subset to
highly variable genes or not}

\item{n_hvg_genes}{int which allows the users to choose the number of highly
variable genes}

\item{labels}{character vector for the cell type labels}
}
\value{
SimpleList DataFrames for Mu (mean per gene per cell type) and
Omega (variance corrected std.dev per gene per cell type)
}
\description{
\code{create_signature} Creates signature from scRNAseq data
}
\examples{
if (requireNamespace("scRNAseq", quietly = TRUE)) {
    library(scRNAseq)
    library(scuttle)
    ## Load scRNaseq
    scRNAseq <- scRNAseq::SegerstolpePancreasData()

    ## remove NA cells
    scRNAseq <- scRNAseq[, !is.na(scRNAseq$`cell type`)]

    ## Normalize (cp10k) and logtransform scRNAseq
    cpm(scRNAseq) <- scuttle::calculateCPM(scRNAseq)
    SingleCellExperiment::logcounts(scRNAseq) <- log1p(cpm(scRNAseq) / 100)

    ## Create signature
    signature <- create_signature(scRNAseq, labels = scRNAseq$`cell type`)
}
}
