% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gather_true_fractions.R
\name{gather_true_fractions}
\alias{gather_true_fractions}
\title{Gather true fractions}
\usage{
gather_true_fractions(scRNAseq, ids, label_col)
}
\arguments{
\item{scRNAseq}{SingleCellExperiment object of which to gather
fractions per sample}

\item{ids}{character vector with ids of samples}

\item{label_col}{character for the column name with the cell type labels}
}
\value{
DataFrame with fractions of all cell types per sample
}
\description{
\code{gather_true_fractions} Gathers true fractions of all cell types per
sample from scRNAseq data
}
\examples{
if (requireNamespace("scRNAseq", quietly = TRUE)) {
    library(scRNAseq)
    ## Load data
    scRNAseq <- scRNAseq::SegerstolpePancreasData()
    ## Subset to 1 healthy and 3 type 2 diabetes samples
    scRNAseq <- scRNAseq[, scRNAseq$individual \%in\% c("H3",
                                                     "T2D1", "T2D2")]
    ## remove NA cells
    scRNAseq <- scRNAseq[, !is.na(scRNAseq$`cell type`)]

    ## remove cells with less than 100 in total cohort
    celltypes_to_remove <- names(table(scRNAseq$`cell type`)
    [(table(scRNAseq$`cell type`) < 100)])
    scRNAseq <- scRNAseq[, !scRNAseq$`cell type` \%in\% celltypes_to_remove]

    true_fractions <- gather_true_fractions(scRNAseq,
        ids = scRNAseq$individual, label_col = "cell type"
    )
}
}
