% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotQCpdf.R
\name{plotQCpdf}
\alias{plotQCpdf}
\title{Plot Outlier Metrics to PDF}
\usage{
plotQCpdf(
  spe,
  sample_id = "sample_id",
  metric = "detected",
  outliers = "local_outliers",
  colors = c("white", "black"),
  stroke = 1,
  point_size = 2,
  width = 5,
  height = 5,
  fname
)
}
\arguments{
\item{spe}{A SpatialExperiment object containing the data to be plotted.}

\item{sample_id}{A character string specifying the column name in
\code{colData(spe)} that contains unique sample identifiers. Default is
'sample_id'.}

\item{metric}{A character string specifying the metric to be visualized
in the plot. This metric should be a column name in \code{colData(spe)}.}

\item{outliers}{A character string specifying the column name in
\code{colData(spe)} that indicates whether a data point is considered an
outlier. Default is local_outliers'.}

\item{colors}{A character vector specifying the colors to be used for the
gradient scale. If length is 2, the gradient will be a single color gradient}

\item{stroke}{A numeric value specifying the border thickness for outlier
points. Default is 1.}

\item{point_size}{A numeric value specifying the size of the points in the
plot. Default is 2.}

\item{width}{A numeric value indicating the width of the plot. Default
is 5.}

\item{height}{A numeric value indicating the height of the plot. Default
is 5.}

\item{fname}{A character string specifying the path and name of the output
PDF file.}
}
\value{
ggplot object if specified. Generates a plot otherwise.
}
\description{
This function generates a PDF file containing plots for each sample in the
SpatialExperiment object, highlighting outliers based on specified metrics.
Each plot visualizes outlier metrics for a single sample, allowing for
easy comparison and analysis across samples.
}
\examples{
library(SpotSweeper)
library(SpatialExperiment)
library(escheR)

# load example data
spe <- STexampleData::Visium_humanDLPFC()

tempFilePath <- file.path(tempdir(), "examplePlot.pdf")

# change from gene id to gene names
rownames(spe) <- rowData(spe)$gene_name

# drop out-of-tissue spots
spe <- spe[, spe$in_tissue == 1]
spe <- spe[, !is.na(spe$ground_truth)]

# Identifying the mitochondrial transcripts in our SpatialExperiment.
is.mito <- rownames(spe)[grepl("^MT-", rownames(spe))]

# Calculating QC metrics for each spot using scuttle
spe <- scuttle::addPerCellQCMetrics(spe, subsets = list(Mito = is.mito))
colnames(colData(spe))

# Identifying local outliers using SpotSweeper
spe <- localOutliers(spe,
                     metric = "sum",
                     direction = "lower",
                     log = TRUE
)

plotQCpdf(spe,
          metric="sum",
          outliers="sum_outliers",
          fname=tempFilePath)

}
