% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualize_slide.R
\name{visualizeSlide}
\alias{visualizeSlide}
\title{Visualize the Visium slide image}
\usage{
visualizeSlide(slide_obj, title = "")
}
\arguments{
\item{slide_obj}{A slide object created or inherited from
\code{createSlide()}.}

\item{title}{(chr) Title of the plot. Default: \code{""}}
}
\value{
A \code{ggplot2} object.
}
\description{
Generate and visualize the tissue image as a ggplot2 object.
Users can manually add and modify layers (e.g. title, axis)
following ggplot2's syntax.
}
\examples{

data(mbrain_raw)
spatial_dir <- system.file(file.path("extdata",
                                     "V1_Adult_Mouse_Brain_spatial"),
                           package = "SpotClean")
mbrain_slide_info <- read10xSlide(tissue_csv_file=file.path(spatial_dir,
                                       "tissue_positions_list.csv"),
             tissue_img_file = file.path(spatial_dir,
                                       "tissue_lowres_image.png"),
             scale_factor_file = file.path(spatial_dir,
                                       "scalefactors_json.json"))
mbrain_obj <- createSlide(mbrain_raw,
                          mbrain_slide_info)
gp <- visualizeSlide(mbrain_obj)
plot(gp)
}
