% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_slide.R
\name{createSlide}
\alias{createSlide}
\title{Create a new slide object}
\usage{
createSlide(count_mat, slide_info, gene_cutoff = 0.1, verbose = TRUE)
}
\arguments{
\item{count_mat}{(matrix of num) The raw gene-by-barcode count matrix.
Can be either standard matrix format or sparse matrix format.}

\item{slide_info}{(list or data.frame) A list of slide information from
\code{read10xSlide()}, or a data frame only containing spot information
like barcode, tissue, imagerow, imagecol, etc.}

\item{gene_cutoff}{(num) Filter out genes with average expressions
among tissue spots below or equal to this cutoff.
Default: 0.1}

\item{verbose}{(logical) Whether print progress information.
Default: \code{TRUE}}
}
\value{
A \code{SummarizedExperiment} object containing
gene expression and spot metadata.
}
\description{
This function takes input of the count matrix
(from \code{read10xRaw} or \code{read10xRawH5}) and slide information
(from \code{read10xSlide} or manually specified data frame) and outputs
a \code{SummarizedExperiment} object
as our slide object for downstream decontamination and visualization.
}
\examples{

data(mbrain_raw)
spatial_dir <- system.file(file.path("extdata",
                                     "V1_Adult_Mouse_Brain_spatial"),
                           package = "SpotClean")
mbrain_slide_info <- read10xSlide(tissue_csv_file=file.path(spatial_dir,
                                       "tissue_positions_list.csv"),
             tissue_img_file = file.path(spatial_dir,
                                       "tissue_lowres_image.png"),
             scale_factor_file = file.path(spatial_dir,
                                       "scalefactors_json.json"))

mbrain_obj <- createSlide(mbrain_raw,
                          mbrain_slide_info)
mbrain_obj
}
