% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{isCOV}
\alias{isCOV}
\title{Validates the given file as a valid COV file}
\usage{
isCOV(coverage_files)
}
\arguments{
\item{coverage_files}{A vector containing the file names of files to be
checked}
}
\value{
\code{TRUE} if all files are valid COV files. \code{FALSE} otherwise
}
\description{
This function takes the path of a possible COV file and checks whether its
format complies with that of the COV format defined by this package.
}
\details{
COV files are BGZF-compressed files. The first 4 bytes of the file must
always be 'COV\1', distinguishing it from BAM or other files in BGZF format.
This function checks whether the given file complies with this.
}
\examples{
se <- SpliceWiz_example_NxtSE()

cov_files <- covfile(se)

isCOV(cov_files) # returns true if these are true COV files
}
\seealso{
\link{processBAM} \link{collateData}
}
