% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/example_data.R
\name{example-SpliceWiz-data}
\alias{example-SpliceWiz-data}
\alias{SpliceWiz_example_bams}
\alias{SpliceWiz_example_NxtSE}
\title{SpliceWiz Example BAMs and NxtSE Experiment Object}
\usage{
SpliceWiz_example_bams()

SpliceWiz_example_NxtSE(novelSplicing = FALSE)
}
\arguments{
\item{novelSplicing}{Whether to import an example NxtSE with novel splice
event discovery.}
}
\value{
In \code{SpliceWiz_example_bams()}: returns a 2-column data frame containing
sample names and BAM paths of the example dataset.

In \code{SpliceWiz_example_NxtSE()}: returns a \linkS4class{NxtSE} object.
}
\description{
\code{SpliceWiz_example_bams()} is a wrapper function to obtain and make a local
copy
of 6 example files provided by the NxtIRFdata companion package to
demonstrate the use of SpliceWiz. See \link[NxtIRFdata:NxtIRFdata-package]{NxtIRFdata::example_bams} for
a description of the provided BAM files. \cr\cr
\code{SpliceWiz_example_NxtSE()} retrieves a ready-made functioning
\linkS4class{NxtSE} object. The steps to reproduce this object is shown
in the example code in \link{makeSE}
}
\section{Functions}{
\itemize{
\item \code{SpliceWiz_example_bams()}: Returns a 2-column data frame, containing
sample names and sample paths (in tempdir()) of example BAM files

\item \code{SpliceWiz_example_NxtSE()}: Returns a (in-memory / realized) NxtSE
object that was pre-generated using the SpliceWiz example reference and
example BAM files

}}
\examples{

# returns a data frame with the first column as sample names, and the
# second column as BAM paths

SpliceWiz_example_bams()

# Returns a NxtSE object created by the example bams aligned to the
# mock NxtSE reference

se <- SpliceWiz_example_NxtSE()
}
\references{
Generation of the mappability files was performed using SpliceWiz using
a method analogous to that described in:

Middleton R, Gao D, Thomas A, Singh B, Au A, Wong JJ, Bomane A, Cosson B,
Eyras E, Rasko JE, Ritchie W.
IRFinder: assessing the impact of intron retention on mammalian gene
expression.
Genome Biol. 2017 Mar 15;18(1):51.
\doi{10.1186/s13059-017-1184-4}
}
\seealso{
\link{makeSE}
}
\keyword{package}
