% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/covPlotly-methods.R
\name{covPlotly-class}
\alias{covPlotly-class}
\alias{getExonRanges}
\alias{getExonRanges,covPlotly-method}
\alias{setResolution}
\alias{setResolution,covPlotly-method}
\alias{showExons}
\alias{showExons,covPlotly-method}
\title{Container for plotly-based coverage plots}
\usage{
\S4method{getExonRanges}{covPlotly}(object)

\S4method{setResolution}{covPlotly}(object, resolution)

\S4method{showExons}{covPlotly}(object)
}
\arguments{
\item{object}{A covPlotly object}

\item{resolution}{How many horizontal pixels of resolution should be shown
in the final plotly object. Set to \code{0} to disable.}
}
\value{
For \code{show()}: A plotly object synthesised by \code{plotView()}
For \code{getExonRanges()}: A named GRanges object containing exon ranges
For \code{showExons()}: A named GRanges object containing exon ranges, and
additionally "shows" the plotly coverage plot with annotation replaced
by named exons
For \code{setResolution()} Returns the \code{covPlotly} object with addition of
resolution set by the corresponding parameter. When \code{show()} is called,
the plotly object with the new coverage resolution will be displayed.
}
\description{
A \code{covPlotly} object is created when \link{plotView} is called using
a \code{covPlotObject} as input. It stores metadata alongside the plotly object,
which allows it to be drawn at various resolutions. Smaller resolutions lead
to faster draws at expense of more jagged plots.
}
\section{Functions}{
\itemize{
\item \code{getExonRanges(covPlotly)}: Returns a named GRanges object containing exon
ranges, without showing the associated plotly object

\item \code{setResolution(covPlotly)}: Returns a covPlotly object after setting
the output resolution of the plotly-based coverage plots.

\item \code{showExons(covPlotly)}: Returns a named GRanges object containing exon
ranges, and shows the plotly object with the annotation track showing the
named exons

}}
\examples{
se <- SpliceWiz_example_NxtSE(novelSplicing = TRUE)

# Assign annotation of the experimental conditions
colData(se)$treatment <- rep(c("A", "B"), each = 3)

# Retrieve coverage data for all samples for the gene "SRSF3" (and surrounds)

dataObj <- getCoverageData(
    se,
    Gene = "SRSF3",
    tracks = colnames(se)
)

plotObj_samples <- getPlotObject(
    dataObj,
    Event = "SE:SRSF3-203-exon4;SRSF3-202-int3"
)

if(interactive()) {

    # Create covPlotly object by setting `usePlotly = TRUE`
    p <- plotView(plotObj_samples, usePlotly = TRUE)

    # Display plotly plot
    show(p)

    # Set resolution to 2000; display new plot
    p <- setResolution(p, resolution = 2000)
    show(p)

    # Display exon annotation along with generated plot;
    # - also returns GRanges object
    gr <- showExons(p)
}

}
\seealso{
\link{plotView}
}
